package ga.examples.quadratic;

import ga.core.goperators.ICrossoverOp;
import ga.core.goperators.ProbabilityOp;
import ga.core.individual.IndividualList;
import ga.core.validation.GAContext;

public class QuadraticClusterCrossoverOp extends ProbabilityOp implements
    ICrossoverOp<QuadraticClusterIndividual> {

  public QuadraticClusterCrossoverOp(final int pCrossOver) {
    super(pCrossOver);
  }

  @Override
  public IndividualList<QuadraticClusterIndividual> crossover(
      final QuadraticClusterIndividual individual1,
      final QuadraticClusterIndividual individual2, final GAContext context) {
    final IndividualList<QuadraticClusterIndividual> list = new IndividualList<QuadraticClusterIndividual>();

    if (doOperate()) {
      final QuadraticClusterIndividual ind1 = individual1.clone();
      final QuadraticClusterIndividual ind2 = individual2.clone();

      final int iCut = getRandom().nextInt(QuadraticIndividual.PARAMETER_COUNT);
      for (int i = 0; i < QuadraticIndividual.PARAMETER_COUNT; i++) {
        if (i >= iCut) {
          // switch parameters
          final int num = ind1.getGenotype().get(i);
          ind1.getGenotype().set(i, ind2.getGenotype().get(i));
          ind2.getGenotype().set(i, num);
        }
      }

      list.add(ind1);
      list.add(ind2);
    } else {
      list.add(individual1);
      list.add(individual2);
    }
    return list;
  }
}
